<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Check if the request method is GET
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve the `id` parameter from the query string (if provided)
$id = isset($_GET['id']) ? intval($_GET['id']) : null;

// Base query to fetch data from the Subscribe table
$query = "SELECT id, email, date, delete_status 
          FROM Subscribe WHERE delete_status=0 ";

// Add a WHERE clause if `id` is provided
if ($id !== null) {
    $query .= " AND id = $id";
}

// Execute the query
$result = mysqli_query($conn, $query);

if ($result) {
    $data = [];
    
    // Fetch data and store it in an array
    while ($row = mysqli_fetch_assoc($result)) {
        // Format the date if needed (optional)
        // $row['date'] = date('Y-m-d H:i:s', strtotime($row['date']));
        $data[] = $row;
    }
    
    // Check if any data was retrieved
    if (!empty($data)) {
        echo json_encode($data);
    } else {
        echo json_encode(["status" => "error", "message" => "No subscription records found"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Failed to fetch subscription records: " . mysqli_error($conn)]);
}

// Close the database connection
mysqli_close($conn);
?>